<?php 
function my_enqueue_scripts() {
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script( 'my-script', plugin_dir_url( __FILE__ ) . 'my-script.js', array( 'wp-color-picker' ), false, true );
}
add_action( 'admin_enqueue_scripts', 'my_enqueue_scripts' );
add_action('admin_menu', 'my_plugin_menu');

function my_plugin_menu() {
    add_options_page( 'Simple Post Slider', 'Simple Post Slider', 'manage_options', 'my-unique-identifier', 'my_plugin_options' );
}

function my_plugin_options() {
    if (!current_user_can('manage_options')) {
        wp_die( __('You do not have sufficient permissions to access this page.') );
    }
    echo '<div class="wrap">';
    echo '<h1>Post Slider Options</h1>';
	echo '<h2>Use shortcode [ajax_post_slider] to show it in any page.</h2>';
    echo '<form method="post" action="options.php">';
    settings_fields( 'my-plugin-settings-group' );
    do_settings_sections( 'my-unique-identifier' );
    submit_button();
    echo '</form>';
	
    echo '</div>';
}

add_action( 'admin_init', 'my_plugin_settings' );

function my_plugin_settings() {
    register_setting( 'my-plugin-settings-group', 'background_color' );
    register_setting( 'my-plugin-settings-group', 'title_color' );
    register_setting( 'my-plugin-settings-group', 'text_color' );
    register_setting( 'my-plugin-settings-group', 'selected_category' );

    add_settings_section( 'my-plugin-settings-section', '', '', 'my-unique-identifier' );

    add_settings_field( 'background_color', 'Choose Background Color', 'my_background_color_callback', 'my-unique-identifier', 'my-plugin-settings-section' );

    add_settings_field( 'title_color', 'Choose Title Color', 'my_title_color_callback', 'my-unique-identifier', 'my-plugin-settings-section' );

    add_settings_field( 'text_color', 'Choose Text Color', 'my_text_color_callback', 'my-unique-identifier', 'my-plugin-settings-section' );

    add_settings_field( 'selected_category', 'Select Category', 'my_category_callback', 'my-unique-identifier', 'my-plugin-settings-section' );
}

function my_category_callback() {
    $categories = get_categories();
    $selected_category = get_option('selected_category');
    echo '<select name="selected_category">';
    foreach ( $categories as $category ) {
        $selected = ($category->term_id == $selected_category) ? 'selected="selected"' : '';
        echo '<option value="' . $category->term_id . '" ' . $selected . '>' . $category->name . '</option>';
    }
    echo '</select>';
}

function my_background_color_callback() {
    echo '<input type="text" name="background_color" value="' . get_option('background_color') . '" class="color-picker" />';
}

function my_title_color_callback() {
    echo '<input type="text" name="title_color" value="' . get_option('title_color') . '" class="color-picker" />';
}

function my_text_color_callback() {
    echo '<input type="text" name="text_color" value="' . get_option('text_color') . '" class="color-picker" />';
}
